/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.serverinfo;

import java.net.URL;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.Region;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.components.UserBlock;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.AbstractScene;
import pro.gravit.launcher.gui.scenes.interfaces.SceneSupportUserBlock;
import pro.gravit.launcher.gui.service.LaunchService;
import pro.gravit.utils.helper.LogHelper;

public class ServerInfoScene
extends AbstractScene
implements SceneSupportUserBlock {
    private static final String SERVER_BUTTON_DEFAULT_IMAGE = "images/servers/example.png";
    private static final String SERVER_BUTTON_CUSTOM_IMAGE = "images/servers/%s.png";
    private UserBlock userBlock;

    public ServerInfoScene(JavaFXApplication application) {
        super("scenes/serverinfo/serverinfo.fxml", application);
    }

    @Override
    protected void doInit() {
        this.userBlock = new UserBlock(this.layout, new AbstractScene.SceneAccessor());
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#back")).setOnAction(e -> {
            try {
                this.switchScene(this.application.gui.serverMenuScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#settings")).setOnAction(e -> {
            try {
                this.switchScene(this.application.gui.settingsScene);
                this.application.gui.settingsScene.reset();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        this.reset();
    }

    @Override
    public void reset() {
        ClientProfile profile = this.application.profilesService.getProfile();
        LookupHelper.lookupIfPossible((Node)this.layout, "#serverName").ifPresent(e -> e.setText(profile.getTitle()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#serverDescriptionPane").ifPresent(e -> {
            Label label = (Label)e.getContent();
            label.setText(profile.getInfo());
        });
        LookupHelper.lookupIfPossible((Node)this.layout, "#savepanel", "#clientSettings").ifPresent(b -> b.setOnAction(e -> {
            try {
                if (this.application.profilesService.getProfile() == null) {
                    return;
                }
                this.switchScene(this.application.gui.optionsScene);
                this.application.gui.optionsScene.reset();
            }
            catch (Exception ex) {
                this.errorHandle(ex);
            }
        }));
        LookupHelper.lookupIfPossible((Node)this.layout, "#savepanel", "#save").ifPresent(e -> e.setOnAction(event -> this.runClient()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#serverLogo").ifPresent(node -> {
            Region serverLogo = (Region)node;
            URL logo = this.application.tryResource(String.format(SERVER_BUTTON_CUSTOM_IMAGE, profile.getUUID().toString()));
            if (logo == null) {
                logo = this.application.tryResource(SERVER_BUTTON_DEFAULT_IMAGE);
            }
            if (logo != null) {
                serverLogo.setBackground(new Background(new BackgroundImage[]{new BackgroundImage(new Image(logo.toString()), BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, new BackgroundSize(0.0, 0.0, true, true, false, true))}));
            }
        });
        this.userBlock.reset();
    }

    private void runClient() {
        ((CompletableFuture)this.application.launchService.launchClient().thenAccept(clientInstance -> {
            if (this.application.runtimeSettings.globalSettings.debugAllClients || clientInstance.getSettings().debug) {
                this.contextHelper.runInFxThread(() -> {
                    try {
                        this.switchScene(this.application.gui.debugScene);
                        this.application.gui.debugScene.onClientInstance((LaunchService.ClientInstance)clientInstance);
                    }
                    catch (Exception ex) {
                        this.errorHandle(ex);
                    }
                });
            } else {
                clientInstance.start();
                ((CompletableFuture)clientInstance.getOnWriteParamsFuture().thenAccept(ok -> {
                    LogHelper.info((String)"Params write successful. Exit...");
                    Platform.exit();
                })).exceptionally(ex -> {
                    this.contextHelper.runInFxThread(() -> this.errorHandle((Throwable)ex));
                    return null;
                });
            }
        })).exceptionally(ex -> {
            this.contextHelper.runInFxThread(() -> this.errorHandle((Throwable)ex));
            return null;
        });
    }

    @Override
    public String getName() {
        return "serverinfo";
    }

    @Override
    public UserBlock getUserBlock() {
        return this.userBlock;
    }
}

